*********************************************************************
10/03/2012: CHANGED DEFAULT INDEX TO ADJ_RS, CHANGED GAP TO BE PER POOR 
			PERSON

4/30/2011: ADDED FSSINC_RR TO POVERTY**** FILES.  ADDED INC 3 & 4

* 1/1/11:  RE-RAN FOR ALL YEARS (SO NOW INCLUDE REF YEARS 64-71)
* 11/09:  CORRECTED GAP CALCULATION FOR OFFICIAL MEASURE, WAS MULTIPLYING BY SCALE
* PUT A FLOOR ON INCOME AT ZERO FOR CALCUALTING GAPS 3/2/2009
* ADDED unadj_wgt FOR GAPS BECAUSE 1964 DATA HAVE AN ADJUSTED MSUPWGT FOR 
  THE HEAD BECAUSE MSUPWGT INCLUDES KIDS UNDER 14 IN THE WEIGHT, BUT WGT DOES NOT
  , 3/1/2009
* ADDED 1964 DATA, 2/2009
*msupwgt has a small # of negatives (85 out of 136,000 in 1973) and
 this makes PROC FREQ generate missing for percent, so set these negatives
 to missing for PROC FREQ (see msupwgt4)
*get identifiers for primary families without other adults or other families
*going to give the sm status of the primary family to the related subfamily for all sm to match
broader CE definition
* exclude the related subfamilies because their values of the following are 
  already included in the values for the primary family
**********************************************************************;

option obs=max;

%macro nasrates6479(yr);
PROC SORT DATA=cpsdata.poverty&yr;
BY famid;
RUN;
data nas_pov;
set cpsdata.poverty&yr;
by famid;

IF 1964 LE &yr LE 1967 AND famrel IN(0,4) AND famtyp NE 2 THEN povhead=1;
   ELSE IF 1968 LE &yr LE 1975 AND FIRST.famid AND ftype NE 4 THEN povhead=1;
   ELSE IF &yr GE 1976 AND FIRST.famid AND fkind NE 2 THEN povhead=1;
ELSE povhead=0;
scale=(fpersons_final-tot_kids+.7*tot_kids)**.7;
hscale=(hpersons-hrelu18+.7*hrelu18)**.7;
*official;
inc1=ftotval_final/scale;
hinc1=htotval/hscale;
inc2=(ftotval_final-fts_tottax)/scale;
hinc2=(htotval-hts_tottax)/hscale;
*pre-tax, pre-social security: offical-(soc security);
inc3=(ftotval_final-fssinc_rr_final)/scale;
hinc3=(htotval-hssinc_rr)/hscale;
*pre-tax, pre-non soc. sec transfers: offical-(wc+ui+vet+ssi+afdc/tanf);
inc4=(ftotval_final-ftot_trans_final+fssinc_rr_final)/scale;
hinc4=(htotval-htot_trans+hssinc_rr)/hscale;


IF 0 LE age LE 17 THEN age1=1;
      ELSE age1=0;
   IF 18 LE age LE 64 THEN age2=1;
      ELSE age2=0;
   IF age GE 65 THEN age3=1;
   ELSE age3=0;

IF 0 LE age LE 17 THEN age_grp=1;
   ELSE IF 18 LE age LE 64 THEN age_grp=2;
   ELSE IF age GE 65 THEN age_grp=3;
   
IF 1976 LE &yr LE 1987 THEN DO;
   IF race2=1 AND reorgn GE 30 THEN r1=1;
      ELSE r1=0;
     IF race2=2 AND reorgn GE 30 THEN r2=1;
	 ELSE r2=0;
     r3=1-r1-r2;
END;
* reorgn NOT AVAILABLE 68-70;
IF 1971 LE &yr LE 1975 THEN DO;
   IF race2=1 AND reorgn NOT IN (8,9,10,11,12) THEN r1=1;
      ELSE r1=0;
     IF race2=2 AND reorgn NOT IN (8,9,10,11,12) THEN r2=1;
	 ELSE r2=0;
     r3=1-r1-r2;
END;
IF 1964 LE &yr LE 1967 THEN DO;
   IF race=1 THEN r1=1;
      ELSE r1=0;
     IF race=2 THEN r2=1;
	 ELSE r2=0;
     r3=1-r1-r2;
END;
IF r1=1 THEN race_head=1;
  ELSE IF r2=1 THEN race_head=2;
  ELSE race_head=3;

ARRAY fam(1:5);
  DO t=1 TO 5;
     IF dem_grp=t THEN fam(t)=1;
       ELSE fam(t)=0; 
  END; 
ARRAY ed(1:4);
  DO t=1 TO 4;
     IF ed_head=t THEN ed(t)=1;
       ELSE ed(t)=0; 
END; 


* hreg NOT AVAILABLE 68-75;
IF 1968 LE &yr LE 1975 THEN DO;
   IF 11 LE state2 LE 23 THEN hreg=1;
	  ELSE IF 31 LE state2 LE 49 THEN hreg=2;
	  ELSE IF 51 LE state2 LE 79 THEN hreg=3;
	  ELSE IF 81 LE state2 LE 99 THEN hreg=4;
END;

ARRAY region(1:4);
   DO t=1 to 4;
	IF hreg=t THEN region(t)=1;
	ELSE region(t)=0;
END;

dem_group2=10*dem_grp+ed_head;
dem_group3=10*dem_grp+race_head; 
dem_group4=10*dem_grp+hreg;
dem_group5=100*dem_grp+10*ed_head+emp_head; 

IF 1964 LE &yr LE 1967 THEN ownhome=.;  
   ELSE IF htenure=1 THEN ownhome=1;
   ELSE IF htenure NE . THEN ownhome=0;

run;

PROC MEANS DATA=nas_pov MEDIAN; 
  VAR inc1 inc2 inc3 inc4 hinc1 hinc2 hinc3 hinc4;
  WEIGHT msupwgt;
  output out=median_temp MEDIAN=med_inc1 med_inc2 med_inc3 med_inc4 med_hinc1 med_hinc2 med_hinc3 med_hinc4;
RUN;

DATA nas_pov;
MERGE nas_pov(IN=in1) cexpov.prices1980(RENAME=(year=ref_year));
BY ref_year;
IF in1;

run;

data nas_pov;
   IF _N_=1 THEN SET cpsdata.tholds81
		(KEEP=inc1_p13_0 inc2_p13_0 inc9_p13_0 inc10_p13_0 hinc1_p13_0 hinc2_p13_0 hinc9_p13_0 hinc10_p13_0
		 RENAME=(inc9_p13_0=inc3_p13_0 inc10_p13_0=inc4_p13_0 hinc9_p13_0=hinc3_p13_0 hinc10_p13_0=hinc4_p13_0));
   IF _N_=1 THEN SET median_temp(KEEP=med_inc1 med_inc2 med_inc3 med_inc4 med_hinc1 med_hinc2 med_hinc3 med_hinc4);
   SET nas_pov;

   IF 1964 LE &yr LE 1967 THEN unadj_wgt=wgt/100;
     ELSE unadj_wgt=msupwgt;

* USE MANUALLY CONSTUCTED POVERTY LINE (POVCUT) FOR 64-67;
IF 1964 LE &yr LE 1967 THEN DO;
  IF ftotval_final LT povcut then pov1=1;
     ELSE pov1=0;
  IF ftotval_final LT povcut*1.5 then pov150=1;
     ELSE pov150=0;
END;
IF 1968 LE &yr LE 1979 THEN DO;
	if ftotval_final<fpovcut_final then pov1=1;
	   else  pov1=0;
	if ftotval_final<fpovcut_final*1.5 then pov150=1;
       else  pov150=0;
END;

IF 1964 LE &yr LE 1967  
		THEN gap_official=povhead*((max(0,povcut-MAX(0,ftotval_final)))*unadj_wgt/100); 
   ELSE IF 1968 LE &yr LE 1979 
		THEN gap_official=povhead*((max(0,fpovcut_final-MAX(0,ftotval_final)))*unadj_wgt/100); 

   pov_gap_official = pov1*msupwgt/100;	   

   ARRAY pov_cpi_(1:4);
   ARRAY pov_pce_(1:4);
   ARRAY pov_cpi150_(1:4);
   ARRAY pov_pce150_(1:4);
   ARRAY pov_cpi75_(1:4);
   ARRAY pov_pce75_(1:4);
   ARRAY pov_cpi50_(1:4);
   ARRAY pov_pce50_(1:4);
   ARRAY pov_cpi25_(1:4);
   ARRAY pov_cpi_adj_(1:4);
   ARRAY pov_cpiu_(1:4);
   ARRAY med_pov_(1:4);

   ARRAY gap_cpi_(1:4);
   ARRAY gap_pce_(1:4);
   ARRAY gap_cpiu_(1:4);
   ARRAY gap_cpi_adj_(1:4);

    ARRAY pov_gap_cpi_(1:4);
    ARRAY pov_gap_pce_(1:4);
    ARRAY pov_gap_cpiu_(1:4);
    ARRAY pov_gap_cpi_adj_(1:4);

   ARRAY inctemp(1:4) inc1-inc4;
   ARRAY thresh(1:4) inc1_p13_0 inc2_p13_0 inc3_p13_0 inc4_p13_0;
   ARRAY med_temp(1:4) med_inc1 med_inc2 med_inc3 med_inc4;

   ARRAY hpov_cpi_(1:4);
   ARRAY hpov_pce_(1:4);
   ARRAY hpov_cpi150_(1:4);
   ARRAY hpov_pce150_(1:4);
   ARRAY hpov_cpi75_(1:4);
   ARRAY hpov_pce75_(1:4);
   ARRAY hpov_cpi50_(1:4);
   ARRAY hpov_pce50_(1:4);
   ARRAY hpov_cpi25_(1:4);
   ARRAY hpov_cpi_adj_(1:4);
   ARRAY hpov_cpiu_(1:4);
   ARRAY med_hpov_(1:4);

   ARRAY hinctemp(1:4) hinc1-hinc4;
   ARRAY hthresh(1:4) hinc1_p13_0 hinc2_p13_0 hinc3_p13_0 hinc4_p13_0;
   ARRAY hmed_temp(1:4) med_hinc1 med_hinc2 med_hinc3 med_hinc4;

if inc1 ne .;
if hinc1 ne .;

   do t=1 to 4;
	IF inctemp(t) GE thresh(t)*cpi THEN pov_cpi_(t)=0;
    ELSE IF inctemp(t) LT thresh(t)*cpi THEN pov_cpi_(t)=1; 

    IF inctemp(t) GE thresh(t)*pce THEN pov_pce_(t)=0;
    ELSE IF inctemp(t) LT thresh(t)*pce THEN pov_pce_(t)=1; 

	IF inctemp(t) GE thresh(t)*cpi*1.5 THEN pov_cpi150_(t)=0;
    ELSE IF inctemp(t) LT thresh(t)*cpi*1.5 THEN pov_cpi150_(t)=1; 

    IF inctemp(t) GE thresh(t)*pce*1.5 THEN pov_pce150_(t)=0;
    ELSE IF inctemp(t) LT thresh(t)*pce*1.5 THEN pov_pce150_(t)=1; 

    IF inctemp(t) GE thresh(t)*cpi*0.75 THEN pov_cpi75_(t)=0;
    ELSE IF inctemp(t) LT thresh(t)*cpi*0.75 THEN pov_cpi75_(t)=1; 

    IF inctemp(t) GE thresh(t)*pce*0.75 THEN pov_pce75_(t)=0;
    ELSE IF inctemp(t) LT thresh(t)*pce*0.75 THEN pov_pce75_(t)=1; 

	IF inctemp(t) GE thresh(t)*cpi*0.50 THEN pov_cpi50_(t)=0;
    ELSE IF inctemp(t) LT thresh(t)*cpi*0.50 THEN pov_cpi50_(t)=1; 

    IF inctemp(t) GE thresh(t)*pce*0.50 THEN pov_pce50_(t)=0;
    ELSE IF inctemp(t) LT thresh(t)*pce*0.50 THEN pov_pce50_(t)=1; 

	IF inctemp(t) GE thresh(t)*cpi*0.25 THEN pov_cpi25_(t)=0;
    ELSE IF inctemp(t) LT thresh(t)*cpi*0.25 THEN pov_cpi25_(t)=1; 

    IF inctemp(t) GE thresh(t)*cpiurs_adj THEN pov_cpi_adj_(t)=0;
    ELSE IF inctemp(t) LT thresh(t)*cpiurs_adj THEN pov_cpi_adj_(t)=1; 

	IF inctemp(t) GE thresh(t)*cpiu THEN pov_cpiu_(t)=0;
    ELSE IF inctemp(t) LT thresh(t)*cpiu THEN pov_cpiu_(t)=1; 

	IF inctemp(t) GE med_temp(t)*0.5 THEN med_pov_(t)=0;
    ELSE IF inctemp(t) LT med_temp(t)*0.5 THEN med_pov_(t)=1; 

*  using resources at the household level;
	IF hinctemp(t) GE hthresh(t)*cpi THEN hpov_cpi_(t)=0;
    ELSE IF hinctemp(t) LT hthresh(t)*cpi THEN hpov_cpi_(t)=1; 

    IF hinctemp(t) GE hthresh(t)*pce THEN hpov_pce_(t)=0;
    ELSE IF hinctemp(t) LT hthresh(t)*pce THEN hpov_pce_(t)=1; 

	IF hinctemp(t) GE hthresh(t)*cpi*1.5 THEN hpov_cpi150_(t)=0;
    ELSE IF hinctemp(t) LT hthresh(t)*cpi*1.5 THEN hpov_cpi150_(t)=1; 

    IF hinctemp(t) GE hthresh(t)*pce*1.5 THEN hpov_pce150_(t)=0;
    ELSE IF hinctemp(t) LT hthresh(t)*pce*1.5 THEN hpov_pce150_(t)=1; 

    IF hinctemp(t) GE hthresh(t)*cpi*0.75 THEN hpov_cpi75_(t)=0;
    ELSE IF hinctemp(t) LT hthresh(t)*cpi*0.75 THEN hpov_cpi75_(t)=1; 

    IF hinctemp(t) GE hthresh(t)*pce*0.75 THEN hpov_pce75_(t)=0;
    ELSE IF hinctemp(t) LT hthresh(t)*pce*0.75 THEN hpov_pce75_(t)=1; 

	IF hinctemp(t) GE hthresh(t)*cpi*0.50 THEN hpov_cpi50_(t)=0;
    ELSE IF hinctemp(t) LT hthresh(t)*cpi*0.50 THEN hpov_cpi50_(t)=1; 

    IF hinctemp(t) GE hthresh(t)*pce*0.50 THEN hpov_pce50_(t)=0;
    ELSE IF hinctemp(t) LT hthresh(t)*pce*0.50 THEN hpov_pce50_(t)=1; 

	IF hinctemp(t) GE hthresh(t)*cpi*0.25 THEN hpov_cpi25_(t)=0;
    ELSE IF hinctemp(t) LT hthresh(t)*cpi*0.25 THEN hpov_cpi25_(t)=1; 

    IF hinctemp(t) GE hthresh(t)*cpiurs_adj THEN hpov_cpi_adj_(t)=0;
    ELSE IF hinctemp(t) LT hthresh(t)*cpiurs_adj THEN hpov_cpi_adj_(t)=1; 

    IF hinctemp(t) GE hthresh(t)*cpiu THEN hpov_cpiu_(t)=0;
    ELSE IF hinctemp(t) LT hthresh(t)*cpiu THEN hpov_cpiu_(t)=1; 

	IF hinctemp(t) GE hmed_temp(t)*0.5 THEN med_hpov_(t)=0;
    ELSE IF hinctemp(t) LT hmed_temp(t)*0.5 THEN med_hpov_(t)=1; 


   gap_cpi_(t)=povhead*((max(0,(thresh(t)*cpi)-MAX(0,inctemp(t))))*unadj_wgt*scale/100); 
   gap_pce_(t)=povhead*((max(0,(thresh(t)*pce)-MAX(0,inctemp(t))))*unadj_wgt*scale/100); 
   gap_cpiu_(t)=povhead*((max(0,(thresh(t)*cpiu)-MAX(0,inctemp(t))))*unadj_wgt*scale/100); 
   gap_cpi_adj_(t)=povhead*((max(0,(thresh(t)*cpiurs_adj)-MAX(0,inctemp(t))))*unadj_wgt*scale/100); 

    pov_gap_cpi_(t)= pov_cpi_(t)*msupwgt/100;   
    pov_gap_pce_(t)= pov_pce_(t)*msupwgt/100;
    pov_gap_cpiu_(t)= pov_cpiu_(t)*msupwgt/100; 
    pov_gap_cpi_adj_(t)= pov_cpi_adj_(t)*msupwgt/100; 

end;

IF msupwgt GT wgt/100 AND age ge 18 THEN pweight_under18=familydifference*wgt/100;
 ELSE IF msupwgt GT wgt/100 AND age LE 17 THEN pweight_under18=(1+familydifference)*wgt/100;
 ELSE IF age LE 17 THEN pweight_under18=wgt/100;
 ELSE pweight_under18=0;

IF age GE 65 THEN pweight_over64=wgt/100;
  ELSE pweight_over64=0;
IF 18 LE age LE 64 THEN pweight_18_64=wgt/100;
  ELSE pweight_18_64=0;


run;

data nas_pov&yr;
SET nas_pov(KEEP=pov1 pov_cpi_2 pov_cpi_adj_2 age1-age3 r1-r3 region1-region4 hreg age_grp
				 fam1-fam5 ref_year msupwgt ownhome ed1-ed4 emp_head tot_kids tot_earnrs fpersons_final
				 dem_grp dem_group2 dem_group3 dem_group4 dem_group5 
				 pweight_over64 pweight_18_64 pweight_under18);
msupwgt4=MAX(0,msupwgt);
RUN;
PROC FREQ DATA=nas_pov&yr;
   TABLE dem_grp / out=cpsdata.out_1_&yr; 
   WEIGHT msupwgt4;
RUN; 
PROC FREQ DATA=nas_pov&yr;
   TABLE dem_group2 / out=cpsdata.out_2_&yr;
   WEIGHT msupwgt4; 
RUN;
PROC FREQ DATA=nas_pov&yr; 
   TABLE dem_group3 / out=cpsdata.out_3_&yr;
   WEIGHT msupwgt4;
RUN; 
PROC FREQ DATA=nas_pov&yr; 
   TABLE dem_group4 / out=cpsdata.out_4_&yr; 
   WEIGHT msupwgt4; 
RUN; 
PROC FREQ DATA=nas_pov&yr; 
   TABLE dem_group5 / out=cpsdata.out_5_&yr; 
   WEIGHT msupwgt4; 
RUN; 

PROC MEANS DATA=nas_pov; 
      VAR pov1 pov150 pov_cpi_1-pov_cpi_4 pov_pce_1-pov_pce_4
	   pov_cpi150_1-pov_cpi150_4 pov_pce150_1-pov_pce150_4
	   pov_cpi75_1-pov_cpi75_4 pov_pce75_1-pov_pce75_4
	   pov_cpi50_1-pov_cpi50_4 pov_pce50_1-pov_pce50_4
	   pov_cpi25_1-pov_cpi25_4 pov_cpi_adj_1-pov_cpi_adj_4
	   pov_cpiu_1-pov_cpiu_4 

	   hpov_cpi_1-hpov_cpi_4 hpov_pce_1-hpov_pce_4
	   hpov_cpi150_1-hpov_cpi150_4 hpov_pce150_1-hpov_pce150_4
	   hpov_cpi75_1-hpov_cpi75_4 hpov_pce75_1-hpov_pce75_4
	   hpov_cpi50_1-hpov_cpi50_4 hpov_pce50_1-hpov_pce50_4
	   hpov_cpi25_1-hpov_cpi25_4 hpov_cpi_adj_1-hpov_cpi_adj_4
	   hpov_cpiu_1-hpov_cpiu_4

	   med_pov_1-med_pov_4 med_hpov_1-med_hpov_4
;
   WEIGHT msupwgt;
   output out=pov&yr MEAN=;
RUN;

PROC SORT DATA=nas_pov; 
  BY dem_grp;
RUN;
 
PROC MEANS DATA=nas_pov; 
  BY dem_grp;
      VAR pov1 pov150 pov_cpi_1-pov_cpi_4 pov_pce_1-pov_pce_4
	   pov_cpi150_1-pov_cpi150_4 pov_pce150_1-pov_pce150_4
	   pov_cpi75_1-pov_cpi75_4 pov_pce75_1-pov_pce75_4
	   pov_cpi50_1-pov_cpi50_4 pov_pce50_1-pov_pce50_4
	   pov_cpi25_1-pov_cpi25_4 pov_cpi_adj_1-pov_cpi_adj_4
	   pov_cpiu_1-pov_cpiu_4 

	   hpov_cpi_1-hpov_cpi_4 hpov_pce_1-hpov_pce_4
	   hpov_cpi150_1-hpov_cpi150_4 hpov_pce150_1-hpov_pce150_4
	   hpov_cpi75_1-hpov_cpi75_4 hpov_pce75_1-hpov_pce75_4
	   hpov_cpi50_1-hpov_cpi50_4 hpov_pce50_1-hpov_pce50_4
	   hpov_cpi25_1-hpov_cpi25_4 hpov_cpi_adj_1-hpov_cpi_adj_4
	   hpov_cpiu_1-hpov_cpiu_4

	   med_pov_1-med_pov_4 med_hpov_1-med_hpov_4
;
   WEIGHT msupwgt;
   output out=povdem&yr MEAN=;
RUN;

PROC MEANS SUM DATA=nas_pov; 
	
      VAR  gap_official gap_cpi_1-gap_cpi_4 gap_pce_1-gap_pce_4 
           gap_cpiu_1-gap_cpiu_4 gap_cpi_adj_1-gap_cpi_adj_4 
            
           pov_gap_official pov_gap_cpi_1-pov_gap_cpi_4 pov_gap_pce_1-pov_gap_pce_4 
           pov_gap_cpiu_1-pov_gap_cpiu_4
           pov_gap_cpi_adj_1-pov_gap_cpi_adj_4;
   output out=gap_all&yr SUM=;
RUN;
PROC MEANS SUM DATA=nas_pov; 
  BY dem_grp;

	  VAR  gap_official gap_cpi_1-gap_cpi_4 gap_pce_1-gap_pce_4 
           gap_cpiu_1-gap_cpiu_4 gap_cpi_adj_1-gap_cpi_adj_4 
            
           pov_gap_official pov_gap_cpi_1-pov_gap_cpi_4 pov_gap_pce_1-pov_gap_pce_4 
           pov_gap_cpiu_1-pov_gap_cpiu_4
           pov_gap_cpi_adj_1-pov_gap_cpi_adj_4;
   output out=gapdem&yr SUM=;
RUN;

PROC SORT DATA=nas_pov; 
  BY hreg;
RUN;
PROC MEANS DATA=nas_pov; 
  BY hreg;
      VAR pov1 pov_cpi_1 pov_cpi_2;
   WEIGHT msupwgt;
   output out=povreg&yr MEAN=;
RUN;
PROC MEANS DATA=nas_pov; 
   BY hreg;
   VAR pov1 pov_cpi_1 pov_cpi_2;
   WEIGHT pweight_under18;
   output out=pov_kidsreg&yr MEAN=;
RUN;
PROC MEANS DATA=nas_pov; 
   BY hreg;
   VAR pov1 pov_cpi_1 pov_cpi_2;
   WEIGHT pweight_18_64;
   output out=pov_adultsreg&yr MEAN=;
RUN;
PROC MEANS DATA=nas_pov; 
   BY hreg;
   VAR pov1 pov_cpi_1 pov_cpi_2;
   WEIGHT pweight_over64;
   output out=pov_oldreg&yr MEAN=;
RUN;

PROC SORT DATA=nas_pov; 
  BY age_grp;
RUN;
PROC MEANS DATA=nas_pov; 
  BY age_grp;
      VAR pov1 pov_cpi_1 pov_cpi_2;
   WEIGHT msupwgt;
   output out=povage&yr MEAN=;
RUN;

PROC SORT DATA=nas_pov; 
  BY hreg age_grp;
RUN;
PROC MEANS DATA=nas_pov; 
  BY hreg age_grp;
      VAR pov1 pov_cpi_1 pov_cpi_2;
   WEIGHT msupwgt;
   output out=povreg_age&yr MEAN=;
RUN;

PROC SORT DATA=nas_pov; 
  BY hreg dem_grp;
RUN;
PROC MEANS DATA=nas_pov; 
  BY hreg dem_grp;
      VAR pov1 pov_cpi_1 pov_cpi_2;
   WEIGHT msupwgt;
   output out=povreg_dem&yr MEAN=;
RUN;


PROC MEANS DATA=nas_pov; 
   VAR pov1 pov_cpi_1 pov_cpi_2;
   WEIGHT pweight_under18;
   output out=pov_kids&yr MEAN=;
RUN;
PROC MEANS DATA=nas_pov; 
   VAR pov1 pov_cpi_1 pov_cpi_2;
   WEIGHT pweight_18_64;
   output out=pov_adults&yr MEAN=;
RUN;
PROC MEANS DATA=nas_pov; 
   VAR pov1 pov_cpi_1 pov_cpi_2;
   WEIGHT pweight_over64;
   output out=pov_old&yr MEAN=;
RUN;


%mend;

%nasrates6479(1964);
%nasrates6479(1965);
%nasrates6479(1966);
%nasrates6479(1967);
%nasrates6479(1968);
%nasrates6479(1969);
%nasrates6479(1970);
%nasrates6479(1971);
%nasrates6479(1972);
%nasrates6479(1973);
%nasrates6479(1974);
%nasrates6479(1975);
%nasrates6479(1976);
%nasrates6479(1977);
%nasrates6479(1978);
%nasrates6479(1979);

filename outfile1 'N:\Private\Poverty Trends\SAS\cps\output\nasrates6479.dat';
filename outfile2 'N:\Private\Poverty Trends\SAS\cps\output\povgaps_6479.dat';
filename outfile3 'N:\Private\Poverty Trends\SAS\cps\output\nasrates_dem_6479.dat';
DATA _null_; 
   SET  pov1964 pov1965 pov1966 pov1967 pov1968 pov1969 pov1970 pov1971
        pov1972 pov1973 pov1974 pov1975 pov1976 pov1977 
		pov1978 pov1979;
   FILE outfile1 lrecl=1500 pad; 
   PUT pov1 pov150 pov_cpi_1-pov_cpi_4 pov_pce_1-pov_pce_4
	   pov_cpi150_1-pov_cpi150_4 pov_pce150_1-pov_pce150_4
	   pov_cpi75_1-pov_cpi75_4 pov_pce75_1-pov_pce75_4
	   pov_cpi50_1-pov_cpi50_4 pov_pce50_1-pov_pce50_4
	   pov_cpi25_1-pov_cpi25_4 pov_cpi_adj_1-pov_cpi_adj_4
	   pov_cpiu_1-pov_cpiu_4

	   hpov_cpi_1-hpov_cpi_4 hpov_pce_1-hpov_pce_4
	   hpov_cpi150_1-hpov_cpi150_4 hpov_pce150_1-hpov_pce150_4
	   hpov_cpi75_1-hpov_cpi75_4 hpov_pce75_1-hpov_pce75_4
	   hpov_cpi50_1-hpov_cpi50_4 hpov_pce50_1-hpov_pce50_4
	   hpov_cpi25_1-hpov_cpi25_4 hpov_cpi_adj_1-hpov_cpi_adj_4
	   hpov_cpiu_1-hpov_cpiu_4

	   med_pov_1-med_pov_4 med_hpov_1-med_hpov_4; 
RUN; 

DATA _null_; 
   SET  povdem1964 povdem1965 povdem1966 povdem1967 povdem1968 povdem1969 povdem1970 povdem1971
        povdem1972 povdem1973 povdem1974 povdem1975 povdem1976 povdem1977 
		povdem1978 povdem1979;
   FILE outfile3 lrecl=1500 pad; 
   PUT pov1 pov150 pov_cpi_1-pov_cpi_2 pov_pce_1-pov_pce_2
	   pov_cpi150_1-pov_cpi150_2 pov_pce150_1-pov_pce150_2
	   pov_cpi75_1-pov_cpi75_2 pov_pce75_1-pov_pce75_2
	   pov_cpi50_1-pov_cpi50_2 pov_pce50_1-pov_pce50_2
	   pov_cpi25_1-pov_cpi25_2 pov_cpi_adj_1-pov_cpi_adj_2
	   pov_cpiu_1-pov_cpiu_2

	   med_pov_1-med_pov_2 med_hpov_1-med_hpov_2; 
RUN; 

DATA _null_; 
   SET gap_all1964 gap_all1965 gap_all1966 gap_all1967 gap_all1968 gap_all1969 gap_all1970 gap_all1971
       gap_all1972 gap_all1973 gap_all1974 gap_all1975 
	   gap_all1976 gap_all1977 gap_all1978 gap_all1979 
	   gapdem1964 gapdem1965 gapdem1966 gapdem1967 gapdem1968 gapdem1969 gapdem1970 gapdem1971
       gapdem1972 gapdem1973 gapdem1974 gapdem1975 
	   gapdem1976 gapdem1977 gapdem1978 gapdem1979;
   FILE outfile2 lrecl=2000 pad;
   PUT dem_grp gap_official gap_cpi_1-gap_cpi_2 gap_pce_1-gap_pce_2
           gap_cpiu_1-gap_cpiu_2 gap_cpi_adj_1-gap_cpi_adj_2 /
 
       dem_grp pov_gap_official pov_gap_cpi_1-pov_gap_cpi_2 pov_gap_pce_1-pov_gap_pce_2
           pov_gap_cpiu_1-pov_gap_cpiu_2
           pov_gap_cpi_adj_1-pov_gap_cpi_adj_2;
RUN;

****************************************************************
RESULTS FOR POVERTY AND MACRO CONDITIONS PAPER
****************************************************************;
FILENAME outfile6 'N:\Private\Poverty and Macro Conditions\SAS output\pov6479.dat';
FILENAME outfile7 'N:\Private\Poverty and Macro Conditions\SAS output\povdem6479.dat';
FILENAME outfile8 'N:\Private\Poverty and Macro Conditions\SAS output\povreg6479.dat';
FILENAME outfile9 'N:\Private\Poverty and Macro Conditions\SAS output\povage6879.dat';
FILENAME outfil10 'N:\Private\Poverty and Macro Conditions\SAS output\povreg_dem6479.dat';
FILENAME outfil11 'N:\Private\Poverty and Macro Conditions\SAS output\povreg_age6879.dat';
FILENAME outfil12 'N:\Private\Poverty and Macro Conditions\SAS output\povage6467.dat';
FILENAME outfil13 'N:\Private\Poverty and Macro Conditions\SAS output\povreg_age6467.dat';

DATA _NULL_; 
   SET  pov1964 pov1965 pov1966 pov1967 pov1968 pov1969 pov1970 pov1971
        pov1972 pov1973 pov1974 pov1975 pov1976 pov1977 pov1978 pov1979;
   FILE outfile6 lrecl=1500 pad; 
   PUT pov1 pov_cpi_1 pov_cpi_2; 
RUN; 
DATA _null_; 
   SET  povdem1964 povdem1965 povdem1966 povdem1967 povdem1968 povdem1969 povdem1970 povdem1971
        povdem1972 povdem1973 povdem1974 povdem1975 povdem1976 povdem1977 
		povdem1978 povdem1979;
   FILE outfile7 lrecl=1500 pad; 
   PUT dem_grp pov1 pov_cpi_1 pov_cpi_2; 
RUN; 
DATA _NULL_; 
   SET  povreg1964 povreg1965 povreg1966 povreg1967 povreg1968 povreg1969 povreg1970 povreg1971
        povreg1972 povreg1973 povreg1974 povreg1975 povreg1976 povreg1977 povreg1978 povreg1979;
   FILE outfile8 lrecl=1500 pad; 
   PUT hreg pov1 pov_cpi_1 pov_cpi_2; 
RUN; 
* NOTE: HAVE TO DO EARLY YEARS SEPARATELY BECAUSE KIDS UNDER 14 NOT IN DATASET;
DATA _NULL_; 
   SET  povage1968 povage1969 povage1970 povage1971
        povage1972 povage1973 povage1974 povage1975 povage1976 povage1977 povage1978 povage1979;
   FILE outfile9 lrecl=1500 pad; 
   PUT age_grp pov1 pov_cpi_1 pov_cpi_2; 
RUN; 
DATA _NULL_; 
   SET  povreg_dem1964 povreg_dem1965 povreg_dem1966 povreg_dem1967 povreg_dem1968 povreg_dem1969 povreg_dem1970 povreg_dem1971
        povreg_dem1972 povreg_dem1973 povreg_dem1974 povreg_dem1975 povreg_dem1976 povreg_dem1977 povreg_dem1978 povreg_dem1979;
   FILE outfil10 lrecl=1500 pad; 
   PUT hreg dem_grp pov1 pov_cpi_1 pov_cpi_2; 
RUN; 
* NOTE: HAVE TO DO EARLY YEARS SEPARATELY BECAUSE KIDS UNDER 14 NOT IN DATASET;
DATA _NULL_; 
   SET  povreg_age1968 povreg_age1969 povreg_age1970 povreg_age1971
        povreg_age1972 povreg_age1973 povreg_age1974 povreg_age1975 povreg_age1976 povreg_age1977 povreg_age1978 povreg_age1979;
   FILE outfil11 lrecl=1500 pad; 
   PUT hreg age_grp pov1 pov_cpi_1 pov_cpi_2; 
RUN; 
* BY AGE_GRP 64-67;
DATA _NULL_; 
   SET  pov_kids1964 pov_adults1964 pov_old1964 
		pov_kids1965 pov_adults1965 pov_old1965 
		pov_kids1966 pov_adults1966 pov_old1966 
		pov_kids1967 pov_adults1967 pov_old1967 ;
   FILE outfil12 lrecl=1500 pad; 
   PUT pov1 pov_cpi_1 pov_cpi_2; 
RUN; 
* BY REGION*AGE_GRP 64-67;
DATA _NULL_; 
   SET  pov_kidsreg1964 pov_adultsreg1964 pov_oldreg1964 
		pov_kidsreg1965 pov_adultsreg1965 pov_oldreg1965 
		pov_kidsreg1966 pov_adultsreg1966 pov_oldreg1966 
		pov_kidsreg1967 pov_adultsreg1967 pov_oldreg1967 ;
   FILE outfil13 lrecl=1500 pad; 
   PUT hreg pov1 pov_cpi_1 pov_cpi_2; 
RUN; 


****************************************************************
DEMOGRAPHICS
****************************************************************;
		
************************
POVERTY FOR BASE YR=1972
************************;

PROC SORT DATA=nas_pov1973;
   BY dem_grp; 
RUN; 
PROC MEANS DATA=nas_pov1973;
   BY dem_grp; 
   VAR pov_cpi_adj_2;
   WEIGHT msupwgt;  
   OUTPUT OUT=cpsdata.pd1_72 MEAN=;
RUN; 
PROC SORT DATA=nas_pov1973;
   BY dem_group2; 
RUN; 
PROC MEANS DATA=nas_pov1973;
   BY dem_group2; 
   VAR pov_cpi_adj_2;
   WEIGHT msupwgt;  
   OUTPUT OUT=cpsdata.pd2_72 MEAN=;
RUN; 
PROC SORT DATA=nas_pov1973;
   BY dem_group3;
RUN; 
PROC MEANS DATA=nas_pov1973;
   BY dem_group3;
   VAR pov_cpi_adj_2; 
   WEIGHT msupwgt;
   OUTPUT OUT=cpsdata.pd3_72 MEAN=;
RUN; 
PROC SORT DATA=nas_pov1973;  
   BY dem_group4;
RUN; 
PROC MEANS DATA=nas_pov1973;
   BY dem_group4;
   VAR pov_cpi_adj_2; 
   WEIGHT msupwgt;  
   OUTPUT OUT=cpsdata.pd4_72 MEAN=;
RUN; 
PROC SORT DATA=nas_pov1973;  
   BY dem_group5;
RUN; 
PROC MEANS DATA=nas_pov1973;
   BY dem_group5;
   VAR pov_cpi_adj_2; 
   WEIGHT msupwgt; 
   OUTPUT OUT=cpsdata.pd5_72 MEAN=;
RUN; 

data group1;
   set nas_pov1973 nas_pov1974;
run;
/*
data group1b;
   set nas_pov1972 nas_pov1973 nas_pov1974 nas_pov1975 
	   nas_pov1976 nas_pov1977 nas_pov1978 nas_pov1979 nas_pov1980;
run;
*/
proc datasets;
   delete nas_pov1972 nas_pov1973 nas_pov1974 nas_pov1975 
	   nas_pov1976 nas_pov1977 nas_pov1978 nas_pov1979 nas_pov1980;
run;

proc means data=nas_pov1964;
  var age1-age3 r1-r3 region1-region4 fam1-fam5 ownhome ed1-ed4 emp_head tot_kids tot_earnrs fpersons_final;
  weight msupwgt;
  output out=g0 MEAN= N=n1;
run;
proc means data=nas_pov1964;
  where pov1=1;
  var age1-age3 r1-r3 region1-region4 fam1-fam5 ownhome ed1-ed4 emp_head tot_kids tot_earnrs fpersons_final;
  weight msupwgt;
  output out=g0p1 MEAN= N=n1;
run;
proc means data=nas_pov1964;
  where pov_cpi_adj_2=1;
  var age1-age3 r1-r3 region1-region4 fam1-fam5 ownhome ed1-ed4 emp_head tot_kids tot_earnrs fpersons_final;
  weight msupwgt;
  output out=g0p3 MEAN= N=n1;
run;

proc means data=group1;
  var age1-age3 r1-r3 region1-region4 fam1-fam5 ownhome ed1-ed4 emp_head tot_kids tot_earnrs fpersons_final;
  weight msupwgt;
  output out=g1 MEAN= N=n1;
run;
proc means data=group1;
  where pov1=1;
  var age1-age3 r1-r3 region1-region4 fam1-fam5 ownhome ed1-ed4 emp_head tot_kids tot_earnrs fpersons_final;
  weight msupwgt;
  output out=g1p1 MEAN= N=n1;
run;
proc means data=group1;
  where pov_cpi_adj_2=1;
  var age1-age3 r1-r3 region1-region4 fam1-fam5 ownhome ed1-ed4 emp_head tot_kids tot_earnrs fpersons_final;
  weight msupwgt;
  output out=g1p3 MEAN= N=n1;
run;

/*
proc means data=group1b;
  var age1-age3 r1-r3 region1-region4 fam1-fam5 ownhome ed1-ed4 emp_head tot_kids tot_earnrs fpersons_final;
  weight msupwgt;
  output out=g1b MEAN= N=n1;
run;
proc means data=group1b;
  where pov1=1;
  var age1-age3 r1-r3 region1-region4 fam1-fam5 ownhome ed1-ed4 emp_head tot_kids tot_earnrs fpersons_final;
  weight msupwgt;
  output out=g1bp1 MEAN= N=n1;
run;
proc means data=group1b;
  where pov_cpi_adj_2=1;
  var age1-age3 r1-r3 region1-region4 fam1-fam5 ownhome ed1-ed4 emp_head tot_kids tot_earnrs fpersons_final;
  weight msupwgt;
  output out=g1bp3 MEAN= N=n1;
run;
*/
FILENAME outfile4 'N:\Private\Poverty Trends\SAS\cps\output\demogr6479.dat';

DATA _null_; 
   SET g0 g1 g0p1 g1p1 g0p3 g1p3;
   FILE outfile4 lrecl=1500 pad; 
   PUT age1-age3 r1-r3 region1-region4 fam1-fam5 ownhome ed1-ed4 emp_head tot_kids 
	   tot_earnrs fpersons_final n1;
RUN; 


****************************************************************
CALCULATE AGE DISTRIBUTION SEPARATELY FOR 1964, BECAUSE THE 
PROCEDURE WE USE THAT ADJUSTS THE HEAD WGT FOR THE FACT THAT 
THOSE UNDER 14 ARE NOT IN THE SURVEY WILL ASSIGN AN ADULT AGE
TO ALL THOSE UNDER 14;
****************************************************************;

proc means SUM DATA=nas_pov1964;
  var msupwgt pweight_over64 pweight_18_64 pweight_under18;
  output out=age64_1 SUM=;
run;
proc means SUM DATA=nas_pov1964;
  where pov1=1;
  var msupwgt pweight_over64 pweight_18_64 pweight_under18;
  output out=age64_2 SUM=;
run;
proc means SUM DATA=nas_pov1964;
  where pov_cpi_adj_2=1;
  var msupwgt pweight_over64 pweight_18_64 pweight_under18;
  output out=age64_3 SUM=;
run;

FILENAME outfile5 'N:\Private\Poverty Trends\SAS\cps\output\age_dist64.dat';

DATA _null_; 
   SET age64_1 age64_2 age64_3;
   FILE outfile5 lrecl=1500 pad; 
   PUT msupwgt pweight_over64 pweight_18_64 pweight_under18;
RUN; 
